#ifndef _GAME_
#define _GAME_
typedef struct Persist Persist;
typedef struct Game Game;
#include "main.h"
#include "level.h"
#include "player.h"
#include "speech.h"
#include "script.h"
struct Persist {
    LandMap * level;
    LandGrid * tiles_grid;
    LandGrid * sprites_grid;
    LandArray * players;
    LandArray * removed_players;
    Player * player;
    str level_name;
    str left_door;
    str right_door;
    str level_number;
    str background;
    int entry_x, entry_y;
    int exit_x, exit_y;
    int gem_count;
    int gems [10];
};
struct Game {
    LandFont * font [3];
    LandAtlas * atlas;
    LandHash * animations;
    bool reload_fonts;
    int reload_ts;
    int mx, my;
    LandHash * tiles;
    LandArray * backgrounds /* [LandImage] */;
    LandView * view;
    LandHash * persist;
    Persist * previous;
    Persist * current;
    float trail_x [300];
    float trail_y [300];
    int trail;
    int trail0;
    int slowmo;
    bool paused;
    int ticks;
    int input_kx;
    int input_ky;
    int input2_kx;
    int input2_ky;
    int ky_ticks;
    bool cutscene;
    float last_gx, last_gy;
    int load_next_level;
    int dead, alive;
    bool feign_dead;
    bool no_ky;
    int somersault;
    int idle;
    bool have_switch;
    LandSprite * door;
    int door_frame;
    int changing;
    LandArray * sounds /* [LandSound*] */;
};
extern str start_music;
Game* game_global(void);
void game_init(void);
void game_tick(void);
void game_draw(void);
void game_done(void);
#endif
